P-Squared (.p2) Exporter for Blender
=================================

This directory contains a Blender extension that exports meshes, textures, lights, animations, etc. to a custom P-Squared `.p2` format.

Quick purpose
-------------
- `__init__.py` registers the Blender operator and UI.
- `export_p2.py` contains the exporter implementation (binary chunk builders, mesh triangles, UV handling, armature/action animation packing) and the `save()` entrypoint.

Supported Blender versions
--------------------------
- This extension targets **Blender version 4.5.x ONLY**. Blender 5.0 introduced large-scale API changes to Animations/Actions/F-Curves that are *not* handled by this extension.

Install & enable in Blender (macOS)
----------------------------------

1. So, you've expanded the io\_scene\_p2\_x.y.z.zip file to a working directory and are reading this README.md file within it. Okay, now:
2. Open Blender -> Edit -> Preferences -> Add-ons. Then, click the down-arrow on the upper right-hand side and select ```Install from Disk...```, browse to and select this same io\_scene\_p2\_x.y.z.zip file, i.e. in the parent of this working directory.
3. Click the ```Enable on Install``` checkbox and click the ```Install from Disk``` button.
4. The P-Squared (.p2) exporter should now be available in the Edit->Preferences->Add-ons list. If not, check that it's enabled.

Testing the Extension
--------------------------
1. Open a simple Blender scene with a mesh and UVs.
2. File -> Export -> P-Squared (.p2). Choose a path and export.

Developer Notes
---------------
- This extension relies on Blender's `bpy` and should be run inside Blender for runtime support (armatures, evaluated meshes, scene.frame_set()).
- `export_p2.py` contains many binary packing helpers (`_3ds_chunk`, `_3ds_*` classes). When you add fields or subchunks, preserve `get_size()` and `write()` behavior.
- FWIW: Even though this exporter is installed to Blender's 'Add-ons' collection, it's written as a modern Blender 'Extension'.